<?php

require_once ('File/XSPF.php');
require_once ('XML/RSS.php');

$songsArray = array();

//Najczęściej słuchane utwory
$xspfObj =& new File_XSPF();
$xspfObj->parseFile('http://ws.audioscrobbler.com/1.0/user/ShuTheMoody/toptracks.xspf');
$topTracks = $xspfObj->getTracks();

//Ostatnio słuchane utwory
$rss =& new XML_RSS('http://ws.audioscrobbler.com/1.0/user/ShuTheMoody/recenttracks.rss');
$rss->parse();
$recentTracks = $rss->getItems();

foreach ($topTracks as $trackObj) {
	$songsArray[] = $trackObj->getCreator() . " - " . $trackObj->getTitle();
}

foreach ($recentTracks as $tracksArray) {
	$tempSong = htmlentities($tracksArray['title'], ENT_COMPAT, 'UTF-8');
	$songsArray[] = str_replace('&ndash;', "-", $tempSong);
}

$songsArray = array_unique($songsArray);
sort($songsArray);

?>
<?= '<?xml version="1.0" encoding="UTF-8" ?>' ?>
<html>
<head><title>Wybór</title></head>
<body>
<form method="GET" action="content.php" target="Content">
<select name="query">
<?php foreach ($songsArray as $key => $value) { ?>
	<option value="<?= $value ?>"><?= $value ?></option>
<?php } ?>
</select>
<input type="submit" value="Go" />
</form>
</html>